varying vec2 pos;
varying vec3 RayOrg;
varying vec3 RayDir;
varying vec3 a;
varying vec3 b;
varying vec3 c;
varying vec3 camera_position;


uniform int ScreenWidth;
uniform int ScreenHeight;
uniform float time;


uniform float camx;
uniform float camy;
uniform float camz;
uniform float camtx;
uniform float camty;
uniform float camtz;
uniform float camroll;
uniform float fov;

void main()
{
	gl_Position = gl_ModelViewProjectionMatrix * gl_Vertex;
	pos = (gl_Position.xy+vec2(1,1))/2.0;
	camera_position=vec3(camx, camy, camz);
	vec3 cam_dir = normalize(vec3(camtx,camty,camtz)-camera_position);
	vec3 cam_up = normalize(vec3(sin(camroll*0.0174532925),0,cos(camroll*0.0174532925)));
	vec3 cam_right = cross(cam_dir,cam_up);
	cam_right = normalize(cam_right);

	cam_up = -cross(cam_dir,cam_right);
	cam_up = normalize(cam_up);

	float FOV = fov;
	float theta = (FOV*3.1415*0.25) / 180.0f;
	float half_width = tan(theta);
	float aspect = (float)ScreenWidth / (float)ScreenHeight;

	float u0 = -half_width * aspect;
	float v0 = -half_width;
	float u1 =  half_width * aspect;
	float v1 =  half_width;
	float dist_to_image = 1;

	a = (u1-u0)*cam_right;
	b = (v1-v0)*cam_up;
	c = camera_position + u0*cam_right + v0*cam_up + cam_dir;



}